# AquaDesigner.rb
#---------------------------------------------------------------------------------------------------
# Version: 0.7
# Compatible: SketchUp 7+ (PC)
#             (autres versions Mac non testes)
#---------------------------------------------------------------------------------------------------
#
# CONTRIBUTEURS
# Philippe RODIER
# philippe.rodier[at]laposte[dot]net
#
# ...
#
#---------------------------------------------------------------------------------------------------

### DEPENDANCES ### --------------------------------------------------------------------------------
require 'sketchup.rb'

### MODULES ### ------------------------------------------------------------------------------------
module AquaDesigner

		class SelObserver < Sketchup::SelectionObserver
			
			def onSelectionAdded(sel, ent)
			
			end
			
			def onSelectionRemoved(sel, ent)
			
			end
			
			def onSelectedCleared(sel)
			
			end
			
			def onSelectionBulkChange(sel)
				sel.each {|e|
					@attr_AquaDesignerVersion = e.get_attribute "AquaDesigner_Generateur", "version"
					puts "Version AquaDesigner = #{@attr_AquaDesignerVersion}"
				}
			end
		end

		class AquaDesignerMaterials
		
			def initialize
				@model = Sketchup.active_model
				@mat_verre = @model.materials.add "Verre"
				@mat_verre.alpha = 0.50
				@mat_verre.color = Sketchup::Color.new(100, 149, 237)
				
				@mat_acrylique = @model.materials.add "Acrylique"
				@mat_acrylique.alpha = 0.50
				@mat_acrylique.color = Sketchup::Color.new(186, 192, 201)
				
				@silicone_translucide = @model.materials.add "Silicone translucide"
				@silicone_translucide.alpha = 0.80
				@silicone_translucide.color = Sketchup::Color.new(200, 200, 200)
				
				@silicone_noir = @model.materials.add "Silicone noir"
				@silicone_noir.alpha = 1
				@silicone_noir.color = Sketchup::Color.new(0, 0, 0)
			end
			
			def MaterialVerre
				return @mat_verre
			end
			
			def MaterialAcrylique
				return @mat_acrylique
			end
			
			def SiliconeTranslucide
				return @silicone_translucide
			end
			
			def SiliconeNoire
				return @silicone_noir
			end
			
		end #class AquaDesignerMaterials
		
		class AquaDesignerRectAquarium
			attr_accessor :aqname
			attr_accessor :aqlongueur
			attr_accessor :aqlargeur
			attr_accessor :aqhauteur
			attr_accessor :aqmateriau
			attr_accessor :is_epuniforme
			attr_accessor :aqepuniforme
			attr_accessor :aqepfront
			attr_accessor :aqepback
			attr_accessor :aqepleft
			attr_accessor :aqepright
			attr_accessor :aqepbottom
			attr_accessor :is_joints
			attr_accessor :aqepjoint
			attr_accessor :aqsilicone
			attr_accessor :entities
			attr_accessor :model
			
			def initialize(aqname, aqlongueur, aqlargeur, aqhauteur, aqmateriau, is_epuniforme, aqepuniforme, aqepfront, aqepback, aqepleft, aqepright, aqepbottom, is_joints, aqepjoint, aqsilicone)
				@aqname = aqname
				@aqlongueur = aqlongueur
				@aqlargeur = aqlargeur
				@aqhauteur = aqhauteur
				@aqmateriau = aqmateriau
				@is_epuniforme = is_epuniforme
				@aqepuniforme = aqepuniforme
				@aqepfront = aqepfront
				@aqepback = aqepback
				@aqepleft = aqepleft
				@aqepright = aqepright
				@aqepbottom = aqepbottom

				@is_joints = is_joints
				@aqepjoint = aqepjoint
				@aqsilicone = aqsilicone
								
				@model = Sketchup.active_model
				@sel = @model.selection
				@sel.add_observer SelObserver.new
				@entities = @model.active_entities
				
				@group = @entities.add_group
		        @group.name = @aqname
				@group.set_attribute "AquaDesigner_Generateur", "version", "0.7"
				@group.set_attribute "AquaDesigner_Aquarium", "longueur", @aqlongueur
				@group.set_attribute "AquaDesigner_Aquarium", "largeur", @aqlargeur
				@group.set_attribute "AquaDEsigner_Aquarium", "hauteur", @aqlargeur
				@group.set_attribute "AquaDesigner_Aquarium", "materiau", @aqmateriau
				@group.set_attribute "AquaDesigner_Aquarium", "is_epuniforme", @is_epuniforme
				@group.set_attribute "AquaDesigner_Aquarium", "epuniforme", @aqepuniforme
				@group.set_attribute "AquaDesigner_Aquarium", "epfront", @aqepfront
				@group.set_attribute "AquaDesigner_Aquarium", "epback", @aqepback
				@group.set_attribute "AquaDesigner_Aquarium", "epleft", @aqepleft
				@group.set_attribute "AquaDesigner_Aquarium", "epright", @aqepright
				@group.set_attribute "AquaDesigner_Aquarium", "epbottom", @aqepbottom
				@group.set_attribute "AquaDesigner_Aquarium", "is_joints", @is_joints
				@group.set_attribute "AquaDesigner_Aquarium", "epjoint", @aqepjoint
				@group.set_attribute "AquaDesigner_Aquarium", "silicone", @aqsilicone
				@group.set_attribute "AquaDesigner_Aquarium", "nom", @aqname
				
				@entities = @group.entities	

				if(@is_joints)
					@epjoint = @aqepjoint
				else
					@epjoint = 0.mm
				end
				
				if(@is_epuniforme)
					@epmateriau = @aqepuniforme
					@longueur_base = @aqlongueur-(2*@epmateriau+2*@epjoint)
					@largeur_base = @aqlargeur-(2*@epmateriau+2*@epjoint)
				else
					@epmateriau = @aqepbottom
					@longueur_base = @aqlongueur-(@aqepleft+@aqepright+2*@epjoint)
					@largeur_base = @aqlargeur-(@aqepfront+@aqepback+2*@epjoint)
				end
				
			end
			
			def create_bottom
				# vitre du fond
				pts = []
				pts[0] = [0, 0, 0]
				pts[1] = [@longueur_base, 0, 0]
				pts[2] = [@longueur_base, @largeur_base, 0]
				pts[3] = [0, @largeur_base, 0]
				@base_group = @entities.add_group
				@base_group.name = @aqname + "#vitre_fond"
				@base_entities = @base_group.entities
				@base = @base_entities.add_face pts
				@base.back_material = @aqmateriau
				@base.material = @aqmateriau
				push = @epmateriau
				push = -push if(@base.normal.dot(Z_AXIS) < 0 )
				@base.pushpull push, true
				
				if(@is_joints)
					# joints fond	
				
					# base avant
					pts = []
					pts [0] = [0-@epjoint, 0, 0]
					pts [1] = [@longueur_base+@epjoint, 0, 0]
					pts [2] = [@longueur_base+@epjoint, 0-@epjoint, 0]
					pts [3] = [0-@epjoint, 0-@epjoint, 0]
					
					@joint_base_av_group = @entities.add_group
					@joint_base_av_group.name = @aqname + "#joints_aquarium"
					@joint_base_av_entities = @joint_base_av_group.entities
					@joint_base_av = @joint_base_av_entities.add_face pts
					@joint_base_av.back_material = @aqsilicone
					@joint_base_av.material = @aqsilicone	
					push = @epmateriau
					push = -push if(@joint_base_av.normal.dot(Z_AXIS) < 0 )
					@joint_base_av.pushpull push, true
					
					# base gauche
					pts = []
					pts [0] = [0, 0, 0]
					pts [1] = [0-@epjoint, 0, 0]
					pts [2] = [0-@epjoint, @largeur_base, 0]
					pts [3] = [0, @largeur_base, 0]
					
					@joint_base_g_group = @entities.add_group
					@joint_base_g_group.name = @aqname + "#joints_aquarium"
					@joint_base_g_entities = @joint_base_g_group.entities
					@joint_base_g = @joint_base_g_entities.add_face pts
					@joint_base_g.back_material = @aqsilicone
					@joint_base_g.material = @aqsilicone
					push = @epmateriau
					push = -push if(@joint_base_g.normal.dot(Z_AXIS) < 0 )
					@joint_base_g.pushpull push, true
					
					# base droit
					pts = []
					pts [0] = [@longueur_base, 0, 0]
					pts [1] = [@longueur_base+@epjoint, 0, 0]
					pts [2] = [@longueur_base+@epjoint, @largeur_base, 0]
					pts [3] = [@longueur_base, @largeur_base, 0]
					
					@joint_base_d_group = @entities.add_group
					@joint_base_d_group.name = @aqname + "#joints_aquarium"
					@joint_base_d_entities = @joint_base_d_group.entities
					@joint_base_d = @joint_base_d_entities.add_face pts
					@joint_base_d.back_material = @aqsilicone
					@joint_base_d.material = @aqsilicone
					push = @epmateriau
					push = -push if(@joint_base_d.normal.dot(Z_AXIS) < 0 )
					@joint_base_d.pushpull push, true
					
					# base arrire
					pts = []
					pts [0] = [@longueur_base+@epjoint, @largeur_base, 0]
					pts [1] = [@longueur_base+@epjoint, @largeur_base+@epjoint, 0]
					pts [2] = [0-@epjoint, @largeur_base+@epjoint, 0]
					pts [3] = [0-@epjoint, @largeur_base, 0]
					
					@joint_base_ar_group = @entities.add_group
					@joint_base_ar_group.name = @aqname + "#joints_aquarium"
					@joint_base_ar_entities = @joint_base_ar_group.entities
					@joint_base_ar = @joint_base_ar_entities.add_face pts
					@joint_base_ar.back_material = @aqsilicone
					@joint_base_ar.material = @aqsilicone
					push = @epmateriau
					push = -push if(@joint_base_ar.normal.dot(Z_AXIS) < 0 )
					@joint_base_ar.pushpull push, true
					
				end
			
			end
			
			def create_right
				# glace flanc droit
				if(@is_epuniforme)
					@epmateriau = @aqepuniforme
				else
					@epmateriau = @aqepright
				end
			
				pts = []
				pts [0] = [@longueur_base+@epjoint, 0, 0]
				pts [1] = [@longueur_base+@epjoint+@epmateriau, 0, 0]
				pts [2] = [@longueur_base+@epjoint+@epmateriau, @largeur_base, 0]
				pts [3] = [@longueur_base+@epjoint, @largeur_base, 0]
				
				@flanc_droit_group = @entities.add_group
				@flanc_droit_group.name = @aqname + "#flanc_droit"
				@flanc_droit_entities = @flanc_droit_group.entities
				@flanc_droit = @flanc_droit_entities.add_face pts
				@flanc_droit.back_material = @aqmateriau
				@flanc_droit.material = @aqmateriau
				push = @aqhauteur
				push = -push if(@flanc_droit.normal.dot(Z_AXIS) < 0 )
				@flanc_droit.pushpull push, true
				
				if(@is_joints)
					# joints d'angle
					# avant droit
					pts = []
					pts [0] = [@longueur_base+@epjoint, 0, 0]
					pts [1] = [@longueur_base+@epjoint+@epmateriau, 0, 0]
					pts [2] = [@longueur_base+@epjoint+@epmateriau, 0-@epjoint, 0]
					pts [3] = [@longueur_base+@epjoint, 0-@epjoint, 0]
					
					@joint_angle_avd_group = @entities.add_group
					@joint_angle_avd_group.name = @aqname + "#joints_aquarium"
					@joint_angle_avd_entities = @joint_angle_avd_group.entities
					@joint_angle_avd = @joint_angle_avd_entities.add_face pts
					@joint_angle_avd.back_material = @aqsilicone
					@joint_angle_avd.material = @aqsilicone
					push = @aqhauteur
					push = -push if(@joint_angle_avd.normal.dot(Z_AXIS) < 0 )
					@joint_angle_avd.pushpull push, true
					
					# arrire droit
					pts = []
					pts [0] = [@longueur_base+@epjoint, @largeur_base, 0]
					pts [1] = [@longueur_base+@epjoint+@epmateriau, @largeur_base, 0]
					pts [2] = [@longueur_base+@epjoint+@epmateriau, @largeur_base+@epjoint, 0]
					pts [3] = [@longueur_base+@epjoint, @largeur_base+@epjoint, 0]
					
					@joint_angle_ard_group = @entities.add_group
					@joint_angle_ard_group.name = @aqname + "#joints_aquarium"
					@joint_angle_ard_entities = @joint_angle_ard_group.entities
					@joint_angle_ard = @joint_angle_ard_entities.add_face pts
					@joint_angle_ard.back_material = @aqsilicone
					@joint_angle_ard.material = @aqsilicone
					push = @aqhauteur
					push = -push if(@joint_angle_ard.normal.dot(Z_AXIS) < 0 )
					@joint_angle_ard.pushpull push, true
				end
		
			end
			
			def create_left
				# glace flanc gauche
				if(@is_epuniforme)
					@epmateriau = @aqepuniforme
				else
					@epmateriau = @aqepleft
				end
				
				pts = []
				pts [0] = [0-(@epjoint), 0, 0]
				pts [1] = [0-(@epjoint+@epmateriau), 0, 0]
				pts [2] = [0-(@epjoint+@epmateriau), @largeur_base, 0]
				pts [3] = [0-(@epjoint), @largeur_base, 0]
				
				@flanc_gauche_group = @entities.add_group
				@flanc_gauche_group.name = @aqname + "#flanc_gauche"
				@flanc_gauche_entities = @flanc_gauche_group.entities
				@flanc_gauche = @flanc_gauche_entities.add_face pts
				@flanc_gauche.back_material = @aqmateriau
				@flanc_gauche.material = @aqmateriau
				push = @aqhauteur
				push = -push if(@flanc_gauche.normal.dot(Z_AXIS) < 0 )
				@flanc_gauche.pushpull push, true
				
				if(@is_joints)
					# joints d'angle 
					# avant gauche
					pts = []
					pts [0] = [0-@epjoint, 0, 0]
					pts [1] = [0-(@epjoint+@epmateriau), 0, 0]
					pts [2] = [0-(@epjoint+@epmateriau), 0-@epjoint, 0]
					pts [3] = [0-@epjoint, 0-@epjoint, 0]
					
					@joint_angle_avg_group = @entities.add_group
					@joint_angle_avg_group.name = @aqname + "#joints_aquarium"
					@joint_angle_avg_entities = @joint_angle_avg_group.entities
					@joint_angle_avg = @joint_angle_avg_entities.add_face pts
					@joint_angle_avg.back_material = @aqsilicone
					@joint_angle_avg.material = @aqsilicone
					push = @aqhauteur
					push = -push if(@joint_angle_avg.normal.dot(Z_AXIS) < 0 )
					@joint_angle_avg.pushpull push, true
					
					# arrire gauche
					pts = []
					pts [0] = [0-@epjoint, @largeur_base, 0]
					pts [1] = [0-(@epjoint+@epmateriau), @largeur_base, 0]
					pts [2] = [0-(@epjoint+@epmateriau), @largeur_base+@epjoint, 0]
					pts [3] = [0-@epjoint, @largeur_base+@epjoint, 0]
					
					@joint_angle_arg_group = @entities.add_group
					@joint_angle_arg_group.name = @aqname + "#joints_aquarium"
					@joint_angle_arg_entities = @joint_angle_arg_group.entities
					@joint_angle_arg = @joint_angle_arg_entities.add_face pts
					@joint_angle_arg.back_material = @aqsilicone
					@joint_angle_arg.material = @aqsilicone
					push = @aqhauteur
					push = -push if(@joint_angle_arg.normal.dot(Z_AXIS) < 0 )
					@joint_angle_arg.pushpull push, true
				end
			end
			
			def create_front
				# Glace avant
				
				if(@is_epuniforme)
					@epmateriau = @aqepuniforme
					pts = []
					pts [0] = [0-(@epjoint+@epmateriau), 0-@epjoint, 0]
					pts [1] = [0-(@epjoint+@epmateriau)+@aqlongueur, 0-@epjoint, 0]
					pts [2] = [0-(@epjoint+@epmateriau)+@aqlongueur, 0-(@epjoint+@epmateriau), 0]
					pts [3] = [0-(@epjoint+@epmateriau), 0-(@epjoint+@epmateriau), 0]
				else
					@epmateriau = @aqepfront
					pts = []
					pts [0] = [0-(@epjoint+@aqepleft), 0-@epjoint, 0]
					pts [1] = [0-(@epjoint+@aqepleft)+@aqlongueur, 0-@epjoint, 0]
					pts [2] = [0-(@epjoint+@aqepleft)+@aqlongueur, 0-(@epjoint+@aqepfront), 0]
					pts [3] = [0-(@epjoint+@aqepleft), 0-(@epjoint+@aqepfront), 0]
				end
				
				@avant_group = @entities.add_group
				@avant_group.name = @aqname + "#vitre_avant"
				@avant_entities = @avant_group.entities
				@avant = @avant_entities.add_face pts
				@avant.back_material = @aqmateriau
				@avant.material = @aqmateriau
				push = @aqhauteur
				push = -push if(@avant.normal.dot(Z_AXIS) < 0 )
				@avant.pushpull push, true
			end
			
			def create_back
				# Glace arrire
				
				if(@is_epuniforme)
					@epmateriau = @aqepuniforme
					pts = []
					pts [0] = [0-(@epjoint+@epmateriau), @largeur_base+@epjoint, 0]
					pts [1] = [0-(@epjoint+@epmateriau)+@aqlongueur, @largeur_base+@epjoint, 0]
					pts [2] = [0-(@epjoint+@epmateriau)+@aqlongueur, @largeur_base+(@epjoint+@epmateriau), 0]
					pts [3] = [0-(@epjoint+@epmateriau), @largeur_base+(@epjoint+@epmateriau), 0]
				else
					@epmateriau = @aqepback
					pts = []
					pts [0] = [0-(@epjoint+@aqepleft), @largeur_base+@epjoint, 0]
					pts [1] = [0-(@epjoint+@aqepleft)+@aqlongueur, @largeur_base+@epjoint, 0]
					pts [2] = [0-(@epjoint+@aqepleft)+@aqlongueur, @largeur_base+(@epjoint+@aqepback), 0]
					pts [3] = [0-(@epjoint+@aqepleft), @largeur_base+(@epjoint+@aqepback), 0]
				end
				
				@arriere_group = @entities.add_group
				@arriere_group.name = @aqname + "#vitre_arrire"
				@arriere_entities = @arriere_group.entities
				@arriere = @arriere_entities.add_face pts
				@arriere.back_material = @aqmateriau
				@arriere.material = @aqmateriau
				push = @aqhauteur
				push = -push if(@arriere.normal.dot(Z_AXIS) < 0 )
				@arriere.pushpull push, true
			end
			
			
		end #class AquaDesignerRectAquarium
			
			
		
		
		### CONSTANTES ### -------------------------------------------------------------------------
		unless file_loaded?(File.basename(__FILE__))
			VERSION = '0.7'
			MODULE_ID = 'AquaDesigner'
			GENERATOR_ID = MODULE_ID + '-' + VERSION
		end
		
		### VARIABLES ### ---------------------------------------------------------------------------
		cmd_create_aquarium = UI::Command.new('Crer un aquarium') {
			wnd_params_open
		}
		cmd_options1 = UI::Command.new('Ceinturage et renforts...') {
			wnd_options1_open
		}
		cmd_about_aquadesigner = UI::Command.new(' propos') {
			wnd_about_open
		}
		unless file_loaded?(File.basename(__FILE__))
			@menu = UI.menu('Plugins').add_submenu('AquaDesigner') 
			@menu.add_item(cmd_create_aquarium)
			@menu.add_item(cmd_options1)
			@menu.add_item(cmd_about_aquadesigner)
						
			toolbar = UI::Toolbar.new("AquaDesigner")
			
			aquarium_cmd = UI::Command.new("Crer un aquarium") { 
				wnd_params_open
			}
			
			ceinturage_cmd = UI::Command.new("Ceinturages et renforts") {
				wnd_options1_open
			}
			
			about_cmd = UI::Command.new(" propos d'AquaDesigner") {
				wnd_about_open
			}
			
			aquarium_cmd.small_icon = "AquaDesigner/gui/images/icon-aqua16.png"
			aquarium_cmd.large_icon = "AquaDesigner/gui/images/icon-aqua24.png"
			aquarium_cmd.tooltip = "Cliquer pour crer un aquarium..."
			aquarium_cmd.status_bar_text = "Cliquer pour crer un aquarium..."
			
			ceinturage_cmd.small_icon = "AquaDesigner/gui/images/icon-ceinturage16.png"
			ceinturage_cmd.large_icon = "AquaDesigner/gui/images/icon-ceinturage24.png"
			ceinturage_cmd.tooltip = "Cliquer pour crer un ceinturage/renfort..."
			ceinturage_cmd.status_bar_text = "Cliquer pour crer un ceinturage/renfort..."
			
			about_cmd.small_icon = "AquaDesigner/gui/images/icon-information16.png"
			about_cmd.large_icon = "AquaDesigner/gui/images/icon-information24.png"
			about_cmd.tooltip = "Cliquer pour afficher les informations  propos d'AquaDesigner..."
			about_cmd.status_bar_text = "Cliquer pour afficher les informations  propos d'AquaDesigner..."
			
			toolbar = toolbar.add_item aquarium_cmd
			toolbar = toolbar.add_item ceinturage_cmd
			toolbar = toolbar.add_separator
			toolbar = toolbar.add_item about_cmd
			toolbar.show
			
			# Cration des matires Verre, Acrylique, Silicone Noir, Silicone translucide
			@aqd_materials = AquaDesignerMaterials::new
						
			UI.add_context_menu_handler do |menu_context|
				menu_context.add_separator
				menu_context = menu_context.add_submenu("AquaDesigner")
				menu_context.add_item("Informations sur l'aquarium..."){}
			end
			
		end
		
		### GUI ### -----------------------------------------------------------------------------------
		pathname = File.expand_path(File.dirname(__FILE__))
		pathname_about = File.join(pathname, 'AquaDesigner/gui/about.html')
		pathname_params = File.join(pathname, 'AquaDesigner/gui/params.html')
		pathname_options1 = File.join(pathname, 'AquaDesigner/gui/options1.html')
		
		# About
		@wnd_about = UI::WebDialog.new('AquaDesigner -  propos', false, 'AquaDesignerAbout', 800, 600, 100, 100, false)
		@wnd_about.set_file pathname_about
		
		# Params
		@wnd_params = UI::WebDialog.new('AquaDesigner - Crer un aquarium', false, 'AquaDesignerParams', 400, 750, 100, 100, false)
		@wnd_params.set_size(400, 750)
		@wnd_params.min_width = 400
		@wnd_params.min_height = 750
				
		@wnd_params.add_action_callback('default_values') { |dialog, params|
			s_longueur = 120.cm.to_l.to_s
			s_largeur = 50.cm.to_l.to_s
			s_hauteur = 50.cm.to_l.to_s
			s_epjoint = 1.mm.to_l.to_s
			s_epuniforme = 8.mm.to_l.to_s
			s_epfront = 8.mm.to_l.to_s
			s_epback = 8.mm.to_l.to_s
			s_epleft = 8.mm.to_l.to_s
			s_epright = 8.mm.to_l.to_s
			s_epbottom = 8.mm.to_l.to_s
			@wnd_params.execute_script("$('#longueur').val('#{s_longueur}')")
			@wnd_params.execute_script("$('#largeur').val('#{s_largeur}')")
			@wnd_params.execute_script("$('#hauteur').val('#{s_hauteur}')")
			@wnd_params.execute_script("$('#ep_joints').val('#{s_epjoint}')")
			@wnd_params.execute_script("$('#ep_uniforme').val('#{s_epuniforme}')")
			@wnd_params.execute_script("$('#ep_front').val('#{s_epfront}')")
			@wnd_params.execute_script("$('#ep_back').val('#{s_epback}')")
			@wnd_params.execute_script("$('#ep_left').val('#{s_epleft}')")
			@wnd_params.execute_script("$('#ep_right').val('#{s_epright}')")
			@wnd_params.execute_script("$('#ep_bottom').val('#{s_epbottom}')")
		}
		
		@wnd_params.add_action_callback('get_units') { |dialog, params|
			s_longueur = @wnd_params.get_element_value("longueur").to_l.to_s
			s_largeur = @wnd_params.get_element_value("largeur").to_l.to_s
			s_hauteur = @wnd_params.get_element_value("hauteur").to_l.to_s
			s_epjoint = @wnd_params.get_element_value("ep_joints").to_l.to_s
			s_epuniforme = @wnd_params.get_element_value("ep_uniforme").to_l.to_s
			s_epfront = @wnd_params.get_element_value("ep_front").to_l.to_s
			s_epback = @wnd_params.get_element_value("ep_back").to_l.to_s
			s_epleft = @wnd_params.get_element_value("ep_left").to_l.to_s
			s_epright = @wnd_params.get_element_value("ep_right").to_l.to_s
			s_epbottom = @wnd_params.get_element_value("ep_bottom").to_l.to_s
			
			@wnd_params.execute_script("$('#longueur').val('#{s_longueur}')")
			@wnd_params.execute_script("$('#largeur').val('#{s_largeur}')")
			@wnd_params.execute_script("$('#hauteur').val('#{s_hauteur}')")
			@wnd_params.execute_script("$('#ep_joints').val('#{s_epjoint}')")
			@wnd_params.execute_script("$('#ep_uniforme').val('#{s_epuniforme}')")
			@wnd_params.execute_script("$('#ep_front').val('#{s_epfront}')")
			@wnd_params.execute_script("$('#ep_back').val('#{s_epback}')")
			@wnd_params.execute_script("$('#ep_left').val('#{s_epleft}')")
			@wnd_params.execute_script("$('#ep_right').val('#{s_epright}')")
			@wnd_params.execute_script("$('#ep_bottom').val('#{s_epbottom}')")
			
		}
		
		@wnd_params.add_action_callback('create') { |dialog, params|
			aqname = @wnd_params.get_element_value("aquaname")
			s_longueur = @wnd_params.get_element_value("longueur")
			longueur = s_longueur.to_l
			s_largeur = @wnd_params.get_element_value("largeur")
			largeur = s_largeur.to_l
			s_hauteur = @wnd_params.get_element_value("hauteur")
			hauteur = s_hauteur.to_l
			materiau = @wnd_params.get_element_value("valmatiere")
			s_epuniforme = @wnd_params.get_element_value("epuniforme")
			s_joints = @wnd_params.get_element_value("joints")
			s_epjoints = @wnd_params.get_element_value("ep_joints")
			epjoints = s_epjoints.to_l
			silicone = @wnd_params.get_element_value("valsilicone")
			
			if(s_epuniforme == "true")
				epuniforme = true
			end
			
			if(s_epuniforme == "false")
				epuniforme = false
			end
			
			s_ep_uniforme = @wnd_params.get_element_value("ep_uniforme")
			ep_uniforme = s_ep_uniforme.to_l
			
			s_ep_front = @wnd_params.get_element_value("ep_front")
			ep_front = s_ep_front.to_l
			
			s_ep_back = @wnd_params.get_element_value("ep_back")
			ep_back = s_ep_back.to_l
			
			s_ep_left = @wnd_params.get_element_value("ep_left")
			ep_left = s_ep_left.to_l
			
			s_ep_right = @wnd_params.get_element_value("ep_right")
			ep_right = s_ep_right.to_l
			
			s_ep_bottom = @wnd_params.get_element_value("ep_bottom")
			ep_bottom = s_ep_bottom.to_l
			
			if(s_joints == "true")
				joints = true
			end
			
			if(s_joints == "false")
				joints = false
			end

			
			aqd_rectAquarium = AquaDesignerRectAquarium::new(aqname, longueur, largeur, hauteur, materiau, epuniforme, ep_uniforme, ep_front, ep_back, ep_left, ep_right, ep_bottom, joints, epjoints, silicone)
			aqd_rectAquarium.create_bottom
			aqd_rectAquarium.create_right
			aqd_rectAquarium.create_left
			aqd_rectAquarium.create_front
			aqd_rectAquarium.create_back
		}
		
		@wnd_params.add_action_callback('close') { |dialog, params|
			@wnd_params.close
		}
		
		@wnd_params.set_file pathname_params
		
		# Options 1
		@wnd_options1 = UI::WebDialog.new('AquaDesigner - Ceinturage et renforts', false, 'AquaDesignerOptions1', 400, 750, 100, 100, false)
		@wnd_options1.set_size(400, 750)
		@wnd_options1.min_width = 400
		@wnd_options1.min_height = 750
		
		@wnd_options1.set_file pathname_options1
		
		# Accesseurs
		def self.wnd_about
			@wnd_about
		end
		#
		def self.wnd_about_open
			@wnd_about.show
		end
		#
		def self.wnd_params
			@wnd_params
		end
		#
		def self.wnd_params_open		
			@wnd_params.show
		end
		#
		def self.wnd_options1
			@wnd_options1
		end
		#
		def self.wnd_options1_open
			@wnd_options1.show
		end
end

file_loaded(File.basename(__FILE__))
